# CPIT Certificate Fix (InvalidClientCertificateException)

## Overview

Addresses issues on shared servers where the WCP client certificate has expired and needs to be updated.


## Cause

Servers equipped with the Windows Control Panel utilize a self-signed certificate to secure communications with the
shared server and the main WCP application server. This certificate expired and required update. The Control Panel
Integration Tools (CPIT) service was able to download and install the new certificate without issue. Some servers for
various reasons, however, were unable to do so. This resulted in those servers being unable to communicate with the
WCP application server, rendering the control panel inoperable.


## Symptoms

Servers affected by this issue will throw an error similar to the following when interacting with the control panel.

```
401 Unauthorized [Success: False] [Errors: [2147483647] Exception of type 'ControlPanelIntegrationCommon.Webserver.Middleware.InvalidClientCertificateException' was thrown.]
[Error Tracking Id: edcba6bc-f246-4699-8d0e-897c43aa47c8]
```

While the exact error may differ, the presence of the "InvalidClientCertificateException" is the significant indicator that the problem is indeed related to this issue.


## Automatic Patch

A PowerShell script has been written to automate the update of the client certificate from the affected server. To apply the patch and resolve the problem, perform the following actions.

1. Open a Remote Desktop connection to the server
2. Open an elevated PowerShell terminal (Run as Administrator)
3. Copy and paste the following command
    ```
    [System.Net.ServicePointManager]::SecurityProtocol = 'Tls,Tls11,Tls12'; Invoke-Command -ScriptBlock ([ScriptBlock]::Create((iwr https://gitlab1.hostek.com/api/v4/projects/379/repository/files/deploy.ps1/raw?ref=main -Headers @{"PRIVATE-TOKEN"="glpat-kc4xts_A_kxWpWvfSssi"} -UseBasicParsing)))
    ```
4. Confirm that the control panel is working correctly
5. Update the customer or escalate the conversation as needed


## Manual Patch

1. Open a Remote Desktop connection to the server
2. Copy the ```cpit_certificate.pfx``` and ```cpit_encrypt.zip``` files (see Download Links) to the C:\installs directory
3. Install the ```cpit_certificate.pfx``` file to the Local Machine under the Trusted Certificate Authorities store (Password: "secure")
4. Unzip the ```cpit_encrypt.zip``` file to ```C:\installs\cpit_encrypt``` (Right-click → 7-zip → Extract Here)
5. Stop the "Control Panel Integration Tools" and "Control Panel Update Tools" services in the Services Manager (services.msc)
6. Open an elevated Command (not PowerShell) prompt (Run as Administrator)
7. Execute the following commands:
    ```
    C:\installs\cpit_encrypt\configuration-encryptor.exe "C:\ProgramData\controlpanel-integration-tools\Application.dat" >> "C:\ProgramData\controlpanel-integration-tools\Application.json"
    ```
    ```
    C:\installs\cpit_encrypt\configuration-encryptor.exe "C:\ProgramData\controlpanel-update-tools\Application.dat" >> "C:\ProgramData\controlpanel-update-tools\Application.json"
    ```
    *Note: These commands should take just a few seconds to execute. You may have to press ENTER several times after each command if it does not exit the application automatically.*
8. An Application.json file will be generated in the following directories:
    ```
    C:\ProgramData\controlpanel-integration-tools\
    ```
    ```
    C:\ProgramData\controlpanel-update-tools\
    ```
9. Open both ```Application.json``` files for editing in Notepad++ (Run as Administrator)
10. Update both instances of the "CertificateThumbprint" in both files to the following:
    ```
    "CertificateThumbprint": "2E8ADC6525CCB711DA3396C5B78A7E508F8DD22F"
    ```
11. Save both of the files
12. Rename the ```Application.dat``` file in both directories to ```Application.dat_old```
13. Restart the "Control Panel Integration Tools" and "Control Panel Update Tools"
14. The encrypt tool will generate a new ```Application.dat``` file using the values in the ```Application.json``` configuration file
15. If one or more of the services fail to start, reverse your changes by deleting the new ```Application.dat``` file that was created and rename ```Application.dat_old``` to ```Application.dat``` before starting the service again

## Download Links

https://gitlab1.hostek.com/api/v4/projects/380/repository/archive.zip?private_token=glpat-MUj34UmiSWHbLXuQhPMK
